/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.remote;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Bom;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.store.MaterialRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.problems.Problem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class SuperplanCollator {
    private SuperplanCollator() {
    }

    public static List<Problem> compareGors(List<GeneralizedOrderRequest> gors1, List<GeneralizedOrderRequest> gors2, List<GeneralizedOrderRequest> gors1Exclusive, List<GeneralizedOrderRequest> gors2Exclusive, List<GeneralizedOrderRequest> gors1Conflicting, List<GeneralizedOrderRequest> gors2Conflicting, List<List<GorChangeComment>> conflictingGorsComments, Set<GorChangeComment> consideredChangeTypes) {
        ArrayList<GeneralizedOrderRequest> gors1Copy = Lists.newArrayList(gors1);
        ArrayList<GeneralizedOrderRequest> gors2Copy = Lists.newArrayList(gors2);
        gors1Exclusive.clear();
        gors2Exclusive.clear();
        gors1Conflicting.clear();
        gors2Conflicting.clear();
        conflictingGorsComments.clear();
        LinkedList<Problem> problems = Lists.newLinkedList();
        ListIterator gors1It = gors1Copy.listIterator();
        block0: while (gors1It.hasNext()) {
            GeneralizedOrderRequest gor1 = (GeneralizedOrderRequest)gors1It.next();
            GeneralizedOrderRequest.State gor1State = gor1.getState();
            if (gor1State == GeneralizedOrderRequest.State.VIRTUAL) {
                gors1It.remove();
                continue;
            }
            ListIterator gors2It = gors2Copy.listIterator();
            while (gors2It.hasNext()) {
                GeneralizedOrderRequest gor2 = (GeneralizedOrderRequest)gors2It.next();
                GeneralizedOrderRequest.State gor2State = gor2.getState();
                if (gor2State == GeneralizedOrderRequest.State.VIRTUAL) {
                    gors2It.remove();
                    continue;
                }
                if (!gor2.getId().equals(gor1.getId())) continue;
                gors1It.remove();
                gors2It.remove();
                ArrayList<GorChangeComment> commentCollector = Lists.newArrayList();
                if (consideredChangeTypes.contains((Object)GorChangeComment.STATE) && gor2State != gor1State && (gor1State != GeneralizedOrderRequest.State.WILL_BE_RELEASED || gor2State != GeneralizedOrderRequest.State.PLANNING)) {
                    commentCollector.add(GorChangeComment.STATE);
                }
                if (consideredChangeTypes.contains((Object)GorChangeComment.RELEASE_DATE) && gor2.getReleaseDate() != gor1.getReleaseDate()) {
                    commentCollector.add(GorChangeComment.RELEASE_DATE);
                }
                if (consideredChangeTypes.contains((Object)GorChangeComment.DUE_DATE) && gor2.getDueDate() != gor1.getDueDate()) {
                    commentCollector.add(GorChangeComment.DUE_DATE);
                }
                if (consideredChangeTypes.contains((Object)GorChangeComment.QTY) && gor2.getRequestedQty() != gor1.getRequestedQty()) {
                    commentCollector.add(GorChangeComment.QTY);
                }
                if (consideredChangeTypes.contains((Object)GorChangeComment.DESCRIPTION) && gor2.getDescription() == null && gor1.getDescription() != null || !gor2.getDescription().equals(gor1.getDescription())) {
                    commentCollector.add(GorChangeComment.DESCRIPTION);
                }
                if (consideredChangeTypes.contains((Object)GorChangeComment.PRIORITY) && gor2.getPriority() != gor1.getPriority()) {
                    commentCollector.add(GorChangeComment.PRIORITY);
                }
                if (consideredChangeTypes.contains((Object)GorChangeComment.PRODUCT) && !gor2.getProduct().equals(gor1.getProduct())) {
                    if (!gor2.hasSelectedActiongram() || gor2.getProduct().getActiongram(gor2.getSelectedActiongram().getName()) != null) {
                        commentCollector.add(GorChangeComment.PRODUCT);
                    } else {
                        problems.add(Problem.createProblem2("03800", gor2, gor2.getProduct(), gor2.getSelectedActiongram()));
                    }
                }
                if (consideredChangeTypes.contains((Object)GorChangeComment.ACTIONGRAM) && gor2.hasSelectedActiongram() && (!gor1.hasSelectedActiongram() || !gor2.getSelectedActiongram().getName().equals(gor1.getSelectedActiongram().getName()))) {
                    if (!gor2.hasSelectedActiongram() || gor2.getProduct().getActiongram(gor2.getSelectedActiongram().getName()) != null) {
                        commentCollector.add(GorChangeComment.ACTIONGRAM);
                    } else {
                        problems.add(Problem.createProblem2("03800", gor2, gor2.getProduct(), gor2.getSelectedActiongram()));
                    }
                }
                if (consideredChangeTypes.contains((Object)GorChangeComment.CUSTOM_PROPERTY) && gor1.getProperties().keySet().equals(gor2.getProperties().keySet())) {
                    for (PropertyDefinition pd : gor1.getProperties().keySet()) {
                        Object prop1 = gor1.getProperty(pd);
                        Object prop2 = gor2.getProperty(pd);
                        if (prop1 == null && prop2 == null || prop1 != null && prop1.equals(prop2)) continue;
                        commentCollector.add(GorChangeComment.CUSTOM_PROPERTY);
                        break;
                    }
                } else if (consideredChangeTypes.contains((Object)GorChangeComment.CUSTOM_PROPERTY)) {
                    commentCollector.add(GorChangeComment.CUSTOM_PROPERTY);
                }
                if (commentCollector.isEmpty()) continue block0;
                gors1Conflicting.add(gor1);
                gors2Conflicting.add(gor2);
                conflictingGorsComments.add(commentCollector);
                continue block0;
            }
        }
        gors1Exclusive.addAll(gors1Copy);
        gors2Exclusive.addAll(gors2Copy);
        return problems;
    }

    public static boolean areProductsSame(Product p1, Product p2) {
        if (p1 == p2) {
            return true;
        }
        if (!p1.getName().equals(p2.getName())) {
            return false;
        }
        if (p1.getActiongrams().size() != p2.getActiongrams().size()) {
            return false;
        }
        for (Actiongram ag1 : p1.getActiongrams()) {
            Actiongram ag2 = p2.getActiongram(ag1.getName());
            if (ag2 == null) {
                return false;
            }
            if (SuperplanCollator.areActiongramsSame(ag1, ag2)) continue;
            return false;
        }
        return true;
    }

    private static boolean areActiongramsSame(Actiongram ag1, Actiongram ag2) {
        if (!ag1.getName().equals(ag2.getName())) {
            return false;
        }
        List<Action> acts1 = ag1.getActions();
        List<Action> acts2 = ag2.getActions();
        if (acts1.size() != acts2.size()) {
            return false;
        }
        for (int i = 0; i < acts1.size(); ++i) {
            Action a2;
            Action a1 = acts1.get(i);
            if (SuperplanCollator.areActionsSame(a1, a2 = acts1.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areActionsSame(Action a1, Action a2) {
        if (!a1.getName().equals(a2.getName())) {
            return false;
        }
        if (!SuperplanCollator.areBomsSame(a1.getBom(), a2.getBom())) {
            return false;
        }
        if (!Comparators.equals(a1.getCapabilityReq(), a2.getCapabilityReq())) {
            return false;
        }
        if (Math.abs(a1.getGranularity() - a2.getGranularity()) > 1.0E-7) {
            return false;
        }
        if (a1.getDivisibility() != a2.getDivisibility()) {
            return false;
        }
        if (a1.getMaxTimeToPrepare() != a2.getMaxTimeToPrepare()) {
            return false;
        }
        if (a1.getMinTimeToPrepare() != a2.getMinTimeToPrepare()) {
            return false;
        }
        if (!SuperplanCollator.areMatQtiesSame(a1.getProduces(), a2.getProduces())) {
            return false;
        }
        if (a1.getProductionTime() != a2.getProductionTime()) {
            return false;
        }
        return a1.getRebuildType().equals(a2.getRebuildType());
    }

    private static boolean areBomsSame(Bom bom1, Bom bom2) {
        if (!bom1.getName().equals(bom2.getName())) {
            return false;
        }
        return SuperplanCollator.areMatQtiesSame(Lists.newArrayList(bom1), Lists.newArrayList(bom2));
    }

    private static boolean areMatQtiesSame(List<? extends MaterialQuantity> matQties1, List<? extends MaterialQuantity> matQties2) {
        if (matQties1.size() != matQties2.size()) {
            return false;
        }
        for (int i = 0; i < matQties1.size(); ++i) {
            MaterialQuantity mq1 = matQties1.get(i);
            MaterialQuantity mq2 = matQties1.get(i);
            if (!mq1.getMaterial().getName().equals(mq2.getMaterial().getName())) {
                return false;
            }
            if (!(Math.abs(mq1.getQty() - mq2.getQty()) > 1.0E-7)) continue;
            return false;
        }
        return true;
    }

    public static void compareMrs(List<MaterialRequest> mrs1, List<MaterialRequest> mrs2, List<MaterialRequest> mrs1Exclusive, List<MaterialRequest> mrs2Exclusive, List<MaterialRequest> mrs1Conflicting, List<MaterialRequest> mrs2Conflicting, List<List<MrChangeComment>> conflictingMrsComments) {
        mrs1Exclusive.clear();
        mrs2Exclusive.clear();
        mrs1Conflicting.clear();
        mrs2Conflicting.clear();
        conflictingMrsComments.clear();
        Function createKey = new Function<MaterialRequest, Tuple<String, Class<?>>>(){

            @Override
            public Tuple<String, Class<?>> apply(MaterialRequest input) {
                return Tuple.create(input.getId(), input.getClass());
            }
        };
        ImmutableMap<Tuple<String, Class<?>>, MaterialRequest> mrs1Map = Maps.uniqueIndex(mrs1, createKey);
        Set mrs1Keys = mrs1Map.keySet();
        ImmutableMap<Tuple<String, Class<?>>, MaterialRequest> mrs2Map = Maps.uniqueIndex(mrs2, createKey);
        Set mrs2Keys = mrs2Map.keySet();
        SuperplanCollator.addFromMap(mrs1Exclusive, mrs1Map, Sets.difference(mrs1Keys, mrs2Keys));
        SuperplanCollator.addFromMap(mrs2Exclusive, mrs2Map, Sets.difference(mrs2Keys, mrs1Keys));
        for (Tuple key : Sets.intersection(mrs1Keys, mrs2Keys)) {
            MaterialRequest mr1 = (MaterialRequest)mrs1Map.get(key);
            MaterialRequest mr2 = (MaterialRequest)mrs2Map.get(key);
            ArrayList<MrChangeComment> commentCollector = Lists.newArrayList();
            if (mr1.getMaterial() != mr2.getMaterial()) {
                commentCollector.add(MrChangeComment.MATERIAL);
            } else if (!Comparators.equals(mr1.getQty(), mr2.getQty(), 1.0E-7)) {
                commentCollector.add(MrChangeComment.QTY);
            } else if (mr1.getTime() != mr2.getTime()) {
                commentCollector.add(MrChangeComment.TIME);
            } else if (mr1 instanceof CustomerRequest && ((CustomerRequest)mr1).getPriority() != ((CustomerRequest)mr2).getPriority()) {
                commentCollector.add(MrChangeComment.PRIORITY);
            } else if (mr2 instanceof SupplyRequest && ((SupplyRequest)mr1).getState() != ((SupplyRequest)mr2).getState()) {
                commentCollector.add(MrChangeComment.STATE);
            }
            if (commentCollector.isEmpty()) continue;
            mrs1Conflicting.add(mr1);
            mrs2Conflicting.add(mr2);
            conflictingMrsComments.add(commentCollector);
        }
    }

    private static void addFromMap(List<MaterialRequest> list, Map<Tuple<String, Class<?>>, MaterialRequest> map, Set<Tuple<String, Class<?>>> selectedKeys) {
        for (Tuple<String, Class<?>> key : selectedKeys) {
            list.add(map.get(key));
        }
    }

    public static enum GorChangeComment {
        DESCRIPTION,
        RELEASE_DATE,
        DUE_DATE,
        QTY,
        STATE,
        ACTIONGRAM,
        CUSTOM_PROPERTY,
        PRIORITY,
        PRODUCT;

    }

    public static enum MrChangeComment {
        MATERIAL,
        QTY,
        TIME,
        PRIORITY,
        STATE;

    }
}

